/*
Dieser Sketch basiert auf der Artnet Library von "natcl"
Sämtliche Ausgabefunktionen wurden von mir erstellt und auf Fuktion getestet.
*/

#include <Artnet.h>
#include <Ethernet.h>
#include <EthernetUdp.h>
#include <SPI.h>
#include <Servo.h>

Artnet artnet;                                                        //Erstellen eines Artnet bzw. Servo Objektes, um die Funktionen der Library nutzen zu können
Servo myservo;

// Change ip and mac address for your setup
byte ip[] = {192, 168, 1, 40};                                        //IP Adresse für das Netzwerk festlegen
byte mac[] = {0x04, 0xE9, 0xE5, 0x00, 0x69, 0xEC};                    
int Values[512];                                                      //Array, in dem sämtliche DMX Werte eines Universums gespeichert werden
int needch = 50;                                                      //benötigte Kanäle - belastet den Arduino nicht unnötig
int Outputs[16]={22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37};    //Deklaration der Binärausgänge
int PwmOut[9]={2,3,4,5,6,7,8,9,12};                                   //Deklaration der Pwm Ausgänge
int pos = 0;                                                          //Winkel des Servos in Grad

void setup()                                                          //Setup Fuktion - wird nur einmal bei Programmstart durchlaufen
{
  artnet.begin(mac, ip);
  myservo.attach(13);                                                 //Weist PWM Pin 13 als Steuerausgang für den Servo zu

  for (int i = 0 ; i < 16 ; i++)
      {
        pinMode(Outputs[i], OUTPUT);                                  //Definition der I/O´s als Ausgänge für die Relais
      }
}

void loop()
{
  if (artnet.read() == ART_DMX)                                       //Ausführen wenn Packete empfangen werden
  {
    for (int i = 0 ; i < needch ; i++)
    {
      Values[i]=(artnet.getDmxFrame()[i]);                            //DMX Werte in das "Value" Array schreiben
    }
  }


  
      //Ausgabe der PWM Kanäle - Achtung, RX0 (Pin0), TX0 (Pin1), Pin 10 und Pin 11 stehen nicht als PWM Ausgänge zur Verfügung!!!

    for (int i = 0 ; i < 9 ; i++)
      {
         analogWrite(PwmOut[i],Values[i]);                            //PWM Ausgabge - Syntax: (Pin Nummer, Duty Cycle von 0 bis 255)
      }





      //Ausgabe für die Servoansteuerung

    pos = map(Values[9], 0, 255, 0, 180);                             //Umrechnen des DMX Wertes von Kanal 10 auf 0 bis 180°
    myservo.write(pos);                                               //Senden des einzustellenden Winkels an den Servo






      //Ausgabe für Binäre Ausgänge mit Sicherheitskanal 11 für Konfetti Shooter. Zum Auslösen den Sicherheitskanal in einen Bereich von 101 bis 149 setzen und den auszulösenden Kanal über 127

    if(100<Values[10]&&Values[10]<150)                                //Sicherheitskanal 11 zwischen 101 und 149
        {
          for (int i = 11 ; i < 27 ; i++)                             //gehe in den Wertebereich ab Kanal 12 bis 27 -> 16 Kanal Relais Board
            {
              if(Values[i]>127)                                       //Wenn der Relaiskanal über 127 hat aktiviere den Output
                {
                  digitalWrite(Outputs[i-11],HIGH);
                }
               else                                                   //sonst deaktiviere den Output
                {
                  digitalWrite(Outputs[i-11],LOW);
                }
            }
        }
      else
      {
        for (int i = 11 ; i < 27 ; i++)
            {
              digitalWrite(Outputs[i-11],LOW);                         //Wenn Sicherheitskanal nicht im Auslösebereich, deaktiviere alle Relais
             }
      }
}

